/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.datasource.db.types;

import de.willuhn.datasource.db.types.Type;
import de.willuhn.datasource.db.types.TypeByteArray;
import de.willuhn.datasource.db.types.TypeDate;
import de.willuhn.datasource.db.types.TypeDouble;
import de.willuhn.datasource.db.types.TypeGeneric;
import de.willuhn.datasource.db.types.TypeInteger;
import de.willuhn.datasource.db.types.TypeLongString;
import de.willuhn.datasource.db.types.TypeString;
import de.willuhn.datasource.db.types.TypeTimestamp;
import de.willuhn.logging.Logger;
import java.util.HashMap;
import java.util.Map;

public class TypeRegistry {
    private static Map types = new HashMap();
    public static final Type TYPE_DEFAULT = new TypeGeneric();

    public static Type getType(String name) {
        if (name == null) {
            return TYPE_DEFAULT;
        }
        Type t = (Type)types.get(name.toLowerCase());
        return t == null ? TYPE_DEFAULT : t;
    }

    public static void register(String name, Type type) {
        if (name == null || type == null) {
            Logger.error((String)"name or type cannot be null");
            return;
        }
        types.put(name.toLowerCase(), type);
    }

    static {
        types.put(null, TYPE_DEFAULT);
        types.put("varchar", new TypeString());
        types.put("longvarchar", new TypeLongString());
        types.put("text", new TypeLongString());
        types.put("longtext", new TypeLongString());
        types.put("date", new TypeDate());
        types.put("datetime", new TypeTimestamp());
        types.put("timestamp", new TypeTimestamp());
        types.put("int", new TypeInteger());
        types.put("double", new TypeDouble());
        types.put("decimal", new TypeDouble());
        types.put("blob", new TypeByteArray());
        types.put("longblob", new TypeByteArray());
        types.put("bytea", new TypeByteArray());
        types.put("timestamptz", new TypeTimestamp());
    }
}

